REM  TXT2DXF.BAS por (Mac Oglesby 980723)

REM  Txt para arquivos dxf (CAD e DeltaCad). Versao em portugus BR

REM Essas observaoes e demo foram escritas para mostrar como transferir
REM pontos de dados x, y calculados para um programa de CAD, como o DeltaCad.
REM Estamos gratos a Fer J. de Vries por disponibilizar o processo e os
REM programas.

REM Passos a seguir: 1) No seu programa QBASIC, abra o nome do arquivo.txt
REM e escreva os pontos de dados x, y para o arquivo de texto. 2) Use o
REM aplicativo CNVXXXX.EXE para ler filename.txt e crie os arquivos "filename.rlt"e "filename.dxf".
REM 3) Filename.rlt pode ser plotado para a tela por SCRPLT.EXE, enquanto o
REM nome do arquivo.dxf pode ser aberto pelo DeltaCad. Os dois programas
REM CNVXXXX.EXE e SCRPLT.EXE foram escritos por Fer J. de Vries. SCRPLT.EXE
REM faz parte do conjunto de programas ZONWVLAK de De Vries.
REM ZONWVLAK e CNVXXXX.EXE estao disponveis a partir de (onde mesmo ?? -
REM s procurando na Internet !)

REM Um grfico de tela QBASIC tem a origem (0,0) no canto superior esquerdo,
REM com X positivo para a direita e o positivo para baixo. CNVXXXX.EXE plota
REM x positivo para a direita, mas Y que tambm  positiva para cima. Entao,
REM invertemos o sinal de Y antes de escrever para o arquivo de texto. Alm
REM disso, uma vez que CNVXXXX.EXE traa automaticamente uma cruz (na camada
REM O) para mostrar a localizaao da origem, voc pode querer mudar todos os
REM dados x, y escritos para filename.txt para alterar a posiao da origem
REM indicada em relaao aos pontos de dados.


REM Formato das informaoes cedidas graciosamente por Fer de Vries

REM OPEN "filename.txt" FOR OUTPUT AS #1  'then write data thusly:

REM for a straight line, 2 statements
REM WRITE #1, 1, x1, y1     'start of line
REM WRITE #1, 2, x2, y2     'end of line

REM for a curved line, several statements
REM (the "curve" is actually a series of segments)
REM WRITE #1, 1, x1, y1     'start of curve
REM WRITE #1, 2, x2, y2     'second point on curve
REM WRITE #1, 2, x3, y3     'third point
REM ...
REM WRITE #1, 2, xn, yn     'last point on curve

REM for an arc, three statements
REM WRITE #1, 3, xbegin, ybegin
REM WRITE #1, 3, xcenter, ycenter
REM WRITE #1, 3, radius, arc     'arc in degrees

REM for a circle, three statements
REM WRITE #1, 4, xbegin, ybegin
REM WRITE #1, 4, xcenter, ycenter
REM WRITE #1, 4, radius, arc     'arc here is 360

REM to put the lines which follow into a particular layer
REM WRITE #1, 9, n, 0     'where n is ASCII code of letter from A to Z,
                          'and 0 (zero) is a dummy.
REM CLOSE #1

REM Demo program draws Equation of Time

REM  You MUST set filename$ to suit your situation

filename$ = "C:\DEMOXX.TXT"     '[disk:] [path] filename.txt
OPEN filename$ FOR OUTPUT AS #1

DIM M$(13): DIM M(13)
FOR J = 1 TO 13
READ M$: M$(J) = M$
READ M: M(J) = M + .5   'day (noon) of year for 1st of month (Jan 1 = 0)
NEXT J

SCREEN 11: CLS     'VGA or SVGA 640 by 480, 2 color
LINE (0, 0)-(640, 480), 1, BF      'Sets background white

LOCATE 1, 1: PRINT "Leia os comentrios listados no programa para instruoes."
LOCATE 28, 1: PRINT "filename$ = "; filename$

WRITE #1, 9, 87, 0     'Axis lines, scale ticks in layer L_W

X0 = 140: Y0 = 220     'screen coordinates of origin for EoT curve

REM  For screen, origin (0,0) is at upper left corner, x is positive
REM  to the right, y is positive down.  CNVXXXX.EXE expects x pos-
REM  itive right, but y positive up.  So, the sign of y is reversed
REM  for y values written to the data file.

REM  You may want to shift the data points in the drawing relative
REM  to the origin.  This won't affect the screen plot.
REM  Use values to suit your needs.  Use ' to disable unwanted values.
'shX = -320: shY = -240   'origin shifted near drawing's center
shX = -X0: shY = -Y0   'origin shifted to drawing's origin
'shX = 0: shY = 0          'origin remains at upper left

REM  The drawing may be scaled up or down by changing scX and/or scY.
REM  Unless scX = scY, the drawing will be distorted, (which may be
REM  what is desired).  The screen plot isn't affected.
'scX = 1: scY = 1     'drawing scale opens at about 61
scX = .01475: scY = .01475     'drawing scale opens near 1


FOR J = -17 TO 17                  'line for each minute
L = .5: IF J = 0 THEN L = -5        'identify X-axis (0 minutes)
LINE (X0 + L, Y0 + 10 * J)-(X0 + 365.5, Y0 + 10 * J), 0
WRITE #1, 1, (X0 + L + shX) * scX, -(Y0 + 10 * J + shY) * scY
WRITE #1, 2, (X0 + 365.5 + shX) * scX, -(Y0 + 10 * J + shY) * scY
NEXT J

FOR K = 1 TO 13           'line for 1st day of each month
L = 170
LINE (X0 + M(K), Y0 - L)-(X0 + M(K), Y0 + L + 5), 0
WRITE #1, 1, (X0 + M(K) + shX) * scX, -(Y0 - L + shY) * scY
WRITE #1, 2, (X0 + M(K) + shX) * scX, -(Y0 + L + 5 + shY) * scY

IF K = 13 THEN 25
FOR K1 = 10 TO 20 STEP 10   'lines for 10th and 20th days of month
L = 170
LINE (X0 + M(K) + K1, Y0 - L)-(X0 + M(K) + K1, Y0 + L), 0
WRITE #1, 1, (X0 + M(K) + K1 + shX) * scX, -(Y0 - L + shY) * scY
WRITE #1, 2, (X0 + M(K) + K1 + shX) * scX, -(Y0 + L + shY) * scY
NEXT K1
25 NEXT K

WRITE #1, 9, 88, 0      'Curve in layer L_X

flag = 1

PI# = 3.141592653#
R2D = 180 / PI#   'convert radians to degrees

FOR N = 0 TO 365
REM  EoT is calculated using a method published by J.W.Spencer in a
REM  paper circulated to the Sundial List by John Pickard, Feb 98.
T = 2 * PI# * (N + .5) / 365
e = .0000075 + .001868 * COS(T) - .032077 * SIN(T)
e = e - .014615 * COS(2 * T) - .040849 * SIN(2 * T)   'EoT in radians
e = e * R2D * 4         'EoT in minutes
x = N + X0 + .5
y = e * 10 + Y0
PSET (x, y), 0           'plot points on screen
WRITE #1, flag, (x + shX) * scX, -(y + shY) * scY  'write x,y to txt file
flag = 2                 'flag equals 1 for 1st point, 2 for others
NEXT N

CLOSE #1

DATA "JAN ",0,"FEV ",31,"MAR ",59,"ABR ",90
DATA "MAI ",120,"JUN ",151,"JUL ",181,"AGO ",212
DATA "SET ",243,"OUT ",273,"NOV ",304,"DEZ ",334,"JAN ",365
END

